@php
 $portfolio = getContent('portfolio.content',true);
$portfolios = App\Models\Portfolio::where('status',1)->orderBy('created_at', 'DESC')->limit(6)->get();
$portfoliosCount = App\Models\Portfolio::where('status',1)->count();
@endphp
<!-- ==================== Our Projects Start Here ==================== -->
<section class="projects-area section-bg py-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <h2 class="text-center fw-bold text-base">{{__($portfolio->data_values->heading)}}</h2>
            </div>
        </div>
        <div class="row gy-5 mt-3">
            @foreach($portfolios as $index=>$item)
                <div class="col-lg-4 col-md-4 d-flex align-items-stretch">
                    <div class="card">
                        <img src="{{getImage(getFilePath('portfolioImage').'/'.$item->image)}}" class="card-img-top rounded-0">
                        <div class="card-body d-flex flex-column p-0 bg-base">
                            <p class="card-text p-4 text-white ">
                                @if(strlen(__($item->sub_title)) >140)
                                {{substr( __($item->sub_title), 0,140).'...' }}
                                @else
                                {{__($item->sub_title)}}
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
<!-- ==================== Our Projects us End Here ==================== -->
